/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.task.TaskErrorIds;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class HThreadGroup
extends ThreadGroup
implements TaskErrorIds {
    private static final String TRACE_MASKT = "XFRMHTGT";
    private static final String TRACE_MASKF = "XFRMHTGF";
    private static final String TRACE_MASKD = "XFRMHTGD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "HThreadGrp");
    private static HThreadGroup defaultThreadGroup = new HThreadGroup();
    private static int nextid = 1;
    private static Object idLock = new Object();
    private static boolean outOfMemoryCaught = false;

    private HThreadGroup() throws NullPointerException, SecurityException {
        super("Default");
    }

    public HThreadGroup(String name) throws NullPointerException, SecurityException {
        super(defaultThreadGroup, name);
    }

    public HThreadGroup(HThreadGroup parent, String name) throws NullPointerException, SecurityException {
        super(parent, name);
    }

    public static HThreadGroup defaultThreadGroup() {
        return defaultThreadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread createThread(Runnable target, String name) throws SecurityException {
        String thdName = name;
        if (thdName == null) {
            thdName = "HThread";
        }
        Object object = idLock;
        synchronized (object) {
            thdName = thdName + "-" + nextid;
            ++nextid;
        }
        return new Thread(this, target, thdName);
    }

    public void uncaughtException(Thread t, Throwable e) {
        ThreadGroup parent = this.getParent();
        if (this.equals(defaultThreadGroup) || parent == null) {
            if (!(e instanceof ThreadDeath)) {
                Trace.trace(TRACE_MASKT, "-> HThreadGroup.uncaughtException()");
                boolean logit = true;
                if (outOfMemoryCaught && e instanceof OutOfMemoryError) {
                    logit = false;
                }
                if (!outOfMemoryCaught && e instanceof OutOfMemoryError) {
                    outOfMemoryCaught = true;
                    try {
                        Class<?> dumpClass = Class.forName("com.ibm.jvm.Dump");
                        Method method = dumpClass.getMethod("JavaDump", null);
                        method.invoke(null, null);
                        method = dumpClass.getMethod("HeapDump", null);
                        method.invoke(null, null);
                    }
                    catch (IllegalAccessException exc) {
                        Trace.trace(TRACE_MASKF, exc);
                    }
                    catch (InvocationTargetException exc) {
                        Trace.trace(TRACE_MASKF, exc);
                    }
                    catch (NoSuchMethodException exc) {
                        Trace.trace(TRACE_MASKF, exc);
                    }
                    catch (ClassNotFoundException exc) {
                        Trace.trace(TRACE_MASKF, exc);
                    }
                }
                Trace.trace(TRACE_MASKT, e);
                if (logit) {
                    FrameworkLog log = new FrameworkLog(classLogInfo, 70, e);
                    log.add(e.toString());
                    log.log();
                }
                Trace.trace(TRACE_MASKT, "<- HThreadGroup.uncaughtException()");
            }
        } else {
            parent.uncaughtException(t, e);
        }
    }
}

